% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A00-surveff.R
\name{plot.surveff}
\alias{plot.surveff}
\title{Plot Method for surveff Objects}
\usage{
\method{plot}{surveff}(
  x,
  type = "surv",
  max_time = NULL,
  strata_to_plot = NULL,
  strata_colors = NULL,
  conf_level = 0.95,
  include_CI = TRUE,
  curve_width = 1,
  CI_alpha = 0.3,
  legend_position = "right",
  legend_title = NULL,
  plot_title = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{surveff} object.}

\item{type}{Type of plot: "surv" for survival curves or "survdiff" for
treatment effect curves. Default "surv".}

\item{max_time}{Maximum time to display on x-axis. If NULL, uses max(eval_times).}

\item{strata_to_plot}{Vector of strata to plot. For \code{type = "surv"}, must be
subset of treatment_levels. For \code{type = "survdiff"}, must be subset of
contrast names (column names of difference_estimates). If NULL, plots all available strata.}

\item{strata_colors}{Vector of color names/codes for strata. Length must match
strata_to_plot. Order matches strata order. If NULL, uses ggplot2 default colors.}

\item{conf_level}{Confidence level for confidence intervals. Default 0.95.}

\item{include_CI}{Logical. Include confidence interval ribbons? Default TRUE.}

\item{curve_width}{Line width for survival/difference curves. Default 1.}

\item{CI_alpha}{Transparency level for CI ribbons (0-1). Default 0.3.}

\item{legend_position}{Position of legend: "right" or "bottom". Default "right".}

\item{legend_title}{Title for legend. If NULL, uses "Treatment" for type="surv"
or "Comparison" for type="survdiff".}

\item{plot_title}{Plot title. If NULL, uses default title based on type.}

\item{...}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Plot Method for surveff Objects
}
\details{
Creates publication-ready plots of survival curves or treatment effects over time.

For \code{type = "surv"}: Plots estimated survival functions with optional
confidence intervals. Y-axis ranges from 0 to 1.

For \code{type = "survdiff"}: Plots estimated treatment effects (survival differences)
with optional confidence intervals. Y-axis is not constrained to [0,1].
}
