% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A01-estimator-weibull.R
\name{surv_weibull}
\alias{surv_weibull}
\title{Estimate Counterfactual Survival Functions Using Weibull Censoring Scores}
\usage{
surv_weibull(
  data,
  time_var,
  event_var,
  treatment_var,
  eval_times = NULL,
  weight_result,
  censoring_formula,
  censoring_control = list(maxiter = 350)
)
}
\arguments{
\item{data}{Data frame.}

\item{time_var}{Name of time variable.}

\item{event_var}{Name of event indicator (1 = event, 0 = censored).}

\item{treatment_var}{Name of treatment variable.}

\item{eval_times}{Numeric vector of time points. If NULL, uses all unique event times.}

\item{weight_result}{Output from \code{estimate_weights()}.}

\item{censoring_formula}{Formula for censoring score model.}

\item{censoring_control}{Control parameters for \code{survreg()}.
Default \code{list(maxiter = 350)}.}
}
\value{
List containing:
  \item{survival_matrix}{Matrix [time x J] of survival function estimates S^(j)(t).}
  \item{eval_times}{Time points evaluated.}
  \item{treatment_levels}{Treatment level values.}
  \item{n_levels}{Number of treatment levels.}
  \item{weights_by_group}{List of weight vectors by treatment group.}
  \item{censoring_scores_by_group}{List of censoring score vectors by group.}
  \item{method, estimand}{Weighting method and target estimand.}
  \item{Etau}{Normalization constant.}
  \item{censoring_result, ps_result, weight_result}{Input objects.}
  \item{design_matrices}{List with W (PS model) and X (censoring model).}
  \item{Z_matrix}{Binary indicator matrix [n x J] for treatment groups.}
  \item{time_vec, event_vec}{Original time and event vectors.}
}
\description{
Estimate Counterfactual Survival Functions Using Weibull Censoring Scores
}
\details{
Estimates counterfactual survival function for each treatment group j:
\deqn{S^{(j)}_w(t) = 1 - \frac{\sum_i w_i I(A_i=j) \delta_i I(T_i \leq t) / K_c^{(j)}(T_i, X_i)}{\sum_i w_i I(A_i=j)}}
}
\keyword{internal}
