% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseResult.R
\name{summariseResult}
\alias{summariseResult}
\title{Summarise variables using a set of estimate functions. The output will be
a formatted summarised_result object.}
\usage{
summariseResult(
  table,
  group = list(),
  includeOverallGroup = FALSE,
  strata = list(),
  includeOverallStrata = TRUE,
  variables = NULL,
  estimates = NULL,
  counts = TRUE,
  weights = NULL
)
}
\arguments{
\item{table}{Table with different records.}

\item{group}{List of groups to be considered.}

\item{includeOverallGroup}{TRUE or FALSE. If TRUE, results for an overall
group will be reported when a list of groups has been specified.}

\item{strata}{List of the stratifications within each group to be considered.}

\item{includeOverallStrata}{TRUE or FALSE. If TRUE, results for an overall
strata will be reported when a list of strata has been specified.}

\item{variables}{Variables to summarise, it can be a list to point to different
set of estimate names.}

\item{estimates}{Estimates to obtain, it can be a list to point to different
set of variables.}

\item{counts}{Whether to compute number of records and number of subjects.}

\item{weights}{Name of the column in the table that contains the weights to
be used when measuring the estimates.}
}
\value{
A summarised_result object with the summarised data of interest.
}
\description{
Summarise variables using a set of estimate functions. The output will be
a formatted summarised_result object.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

x <- cdm$cohort1 |>
  addDemographics()

# summarise all variables with default estimates
result <- summariseResult(x)
result

# get only counts of records and subjects
result <- summariseResult(x, variables = character())
result

# specify variables and estimates
result <- summariseResult(
  table = x,
  variables = c("cohort_start_date", "age"),
  estimates = c("mean", "median", "density")
)
result

# different estimates for each variable
result <- summariseResult(
  table = x,
  variables = list(c("age", "prior_observation"), "sex"),
  estimates = list(c("min", "max"), c("count", "percentage"))
)

}

}
