% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_transform.R
\name{skewness_kurtosis}
\alias{skewness_kurtosis}
\alias{kurtosis}
\alias{skewness}
\title{Sample skewness and Sample Kurtosis.}
\usage{
kurtosis(x)

skewness(x)
}
\arguments{
\item{x}{univariate data sample}
}
\value{
\code{kurtosis} returns sample kurtosis.

\code{skewness} returns sample skewness.
}
\description{
Sample skewness and Sample Kurtosis.
}
\details{
Sample kurtosis is
\deqn{
\hat{\kappa}_4 =
\dfrac{1}{n-1} \sum_{i = 1}^n \left(\dfrac{X_i - \bar{X}}{S}\right)^4.
}

Sample skewness is
\deqn{
\hat{\kappa}_3 =
\dfrac{1}{n-1} \sum_{i = 1}^n \left(\dfrac{X_i - \bar{X}}{S}\right)^3.
}
}
\examples{
set.seed(123)
y <- rnorm(100)
kurtosis(y)
set.seed(123)
x <- rnorm(100)
skewness(x)
}
