% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_future_income.R
\name{plot_future_income}
\alias{plot_future_income}
\title{Plot future income structure over household life cycle}
\usage{
plot_future_income(
  scenario,
  period = c("yearly", "monthly"),
  y_limits = c(NA, NA)
)
}
\arguments{
\item{scenario}{A \code{tibble} with nested columns -
the result of \code{\link[=simulate_scenario]{simulate_scenario()}}. Data for a single scenario.}

\item{period}{A character. The amounts can be shown
as yearly values (default) or averaged per month values.}

\item{y_limits}{A numeric vector of two values. Y-axis limits.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plot future income structure over household life cycle
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "1980-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 7000 * 12",
    "members$older$age > 65 ~ 3000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "TRUE ~ 5000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)
portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg = 0.20, 
    tax_rate_ordinary_income = 0.40
  )

scenario <- 
  simulate_scenario(
   household = household,
   portfolio = portfolio,
   current_date = "2020-07-15"
  )

plot_future_income(scenario, "monthly")
\dontshow{\}) # examplesIf}
}
