% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgreater_beta.r
\name{pgreater_beta}
\alias{pgreater_beta}
\title{Calculate the Futility Stopping Probability for Binary Endpoint with Beta Distribution}
\usage{
pgreater_beta(a1, b1, a2, b2, delta, side, ...)
}
\arguments{
\item{a1, b1}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)}, current estimated \eqn{\alpha} for the control group.}

\item{a2, b2}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)}, current estimated \eqn{\alpha} for the treatment group which is compared to the control group.}

\item{delta}{expected difference in success probabilities between the control group and the treatment group.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to stats::integrate() (such as rel.tol) from this function.}
}
\value{
a posterior probability of \eqn{Pr(p_k>p_{{\sf control}}+\delta|{\sf data})} with \code{side} equals to 'upper';
a posterior probability of \eqn{Pr(p_{{\sf control}}>p_k+\delta|{\sf data})} with \code{side} equals to 'lower'.
}
\description{
Calculate the futility stopping probability in Bayesian response-adaptive randomization with
a control group using the Thall \eqn{\&} Wathen method for binary outcomes. The conjugate prior distributions follow
Beta (\eqn{Beta(\alpha,\beta)}) distributions and can be specified individually for each treatment group.
}
\details{
This function calculates the results of \eqn{Pr(p_k>p_{{\sf control}}+\delta|{\sf data})} for \code{side} equals to
'upper' and the results of \eqn{Pr(p_{{\sf control}}>p_k+\delta|{\sf data})} for \code{side} equals to 'lower'.
The result indicates the posterior probability of stopping a treatment group due to futility around \eqn{1\%} in Bayesian
response-adaptive randomization with a control arm using Thall \eqn{\&} Wathen method, with accumulated results
during the conduct of trials.
}
\examples{
pgreater_beta(a1=8, b1=10,a2=5, b2=19, delta=0.1, side='upper')
pgreater_beta(a1=65, b1=79,a2=58, b2=68, delta=0, side='lower')
}
\references{
\insertRef{Wathen2017}{RARtrials}
}
