% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_public.R
\name{getAwPfromBathy}
\alias{getAwPfromBathy}
\title{Bathymetry interpreter}
\usage{
getAwPfromBathy(
  bathy,
  hgrid = seq(min(bathy[, 2]), max(bathy[, 2]), diff(range(bathy[, 2]))/1000),
  segmentLength = sum(sqrt(apply(apply(bathy, 2, diff)^2, 1, sum)))/1000
)
}
\arguments{
\item{bathy}{data frame, 2 columns containing abscissa (increasing values) and stage.}

\item{hgrid}{numeric vector, grid of h values where A, w and P are computed.
By default 1000 values in the range of bathymetry's z.}

\item{segmentLength}{numeric, segment length for bathymetry subsampling.
By default 1/1000 of the total bathymetry's perimeter.}
}
\value{
A 4-column dataframe containing h, A(h), w(h) and P(h)
}
\description{
Compute Area A(h), width w(h) and wet perimeter P(h) from a bathymetry profile (a,z).
}
\examples{
bathy=data.frame(a=c(0,0,0,1,2,2,4,6,8),h=c(3,2,0,-0.5,0,2,2.0001,2.3,3))
plot(bathy,type='l')
df=getAwPfromBathy(bathy)
plot(df$h,df$A,type='l')
plot(df$h,df$w,type='l')
plot(df$h,df$P,type='l')
}
