% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPhosFate.R
\name{transport,RPhosFate-method}
\alias{transport,RPhosFate-method}
\alias{transport}
\title{Transport}
\usage{
\S4method{transport}{RPhosFate}(x, substance = "PP")
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calculates and writes substance retentions, transports and cell loads as well
as transfers to disk.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- erosionPrerequisites(x)
x <- erosion(x)
x <- emission(x, "PP")
x <- transportPrerequisites(x)

x <- transport(x, "PP")}

}
\references{
\cite{Engman, E.T., 1986. Roughness coefficients for routing surface runoff.
Journal of Irrigation and Drainage Engineering 112, 39–53.}

\cite{Molnár, P., Ramírez, J.A., 1998. Energy dissipation theories and
optimal channel characteristics of river networks. Water Resources Research
34, 1809–1818. https://doi.org/10.1029/98WR00983}
}
\seealso{
\code{\link{firstRun}}, \code{\link{subsequentRun}}
}
