% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vamp_functions.R
\name{runPlugins}
\alias{runPlugins}
\title{Run Multiple Vamp Plugins on Audio Data in a Single Pass}
\usage{
runPlugins(
  wave,
  keys,
  params = NULL,
  useFrames = FALSE,
  blockSize = NULL,
  stepSize = NULL,
  verbose = FALSE,
  dropIncompleteFinalFrame = TRUE
)
}
\arguments{
\item{wave}{Wave object or filename (same as \code{runPlugin}).}

\item{keys}{Character vector of plugin keys in "library:plugin" format.}

\item{params}{Optional list of parameter lists (either a list-of-lists, a single list applied to all, or a named list keyed by plugin key).}

\item{useFrames, blockSize, stepSize, verbose, dropIncompleteFinalFrame}{Same semantics as \code{runPlugin}.}
}
\value{
A named list where each element corresponds to a plugin key and contains that plugin's outputs (same structure as \code{runPlugin}).
}
\description{
Executes multiple Vamp plugins on the same audio data in a single audio-read loop.
All plugins must use the same blockSize and stepSize (either their preferred values
must match or the caller must provide explicit \code{blockSize}/\code{stepSize} that apply to all).
}
