% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imports.R
\docType{package}
\name{RegimeChange-package}
\alias{RegimeChange}
\alias{RegimeChange-package}
\title{RegimeChange: Comprehensive Regime Change Detection in Time Series}
\description{
A unified framework for detecting regime changes (changepoints) in time series data. Implements both frequentist methods including Cumulative Sum (CUSUM, Page (1954) \doi{10.1093/biomet/41.1-2.100}), Pruned Exact Linear Time (PELT, Killick, Fearnhead, and Eckley (2012) \doi{10.1080/01621459.2012.737745}), Binary Segmentation, and Wild Binary Segmentation, as well as Bayesian methods such as Bayesian Online Changepoint Detection (BOCPD, Adams and MacKay (2007) \url{https://arxiv.org/abs/0710.3742}) and Shiryaev-Roberts. Supports offline analysis for retrospective detection and online monitoring for real-time surveillance. Provides rigorous uncertainty quantification through confidence intervals and posterior distributions. Handles univariate and multivariate series with detection of changes in mean, variance, trend, and distributional properties.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/IsadoreNabi/RegimeChange}
  \item Report bugs at \url{https://github.com/IsadoreNabi/RegimeChange/issues}
}

}
\author{
\strong{Maintainer}: José Mauricio Gómez Julián \email{isadorenabi@pm.me} (\href{https://orcid.org/0009-0000-2412-3150}{ORCID})

}
