% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvbinary_QA.R
\name{rmvbinary_QA}
\alias{rmvbinary_QA}
\title{Simulating correlated binary variables using the algorithm
  by Qaqish (2003)}
\usage{
rmvbinary_QA(n, R, p)
}
\arguments{
\item{n}{Sample size}

\item{R}{Correlation matrix}

\item{p}{Vector of marginal probabilities}
}
\value{
Sample (n x p)-matrix representing a random sample of size n
  from the specified multivariate binary distribution.
}
\description{
Generation of random sample of binary correlated variables
}
\details{
The function implements the algorithm proposed by Qaqish (2003) to
generate a random sample of d (=length(p)) correlated binary
variables. The sample is generated based on given marginal
probabilities p of the d variables and their correlation matrix
R. The algorithm starts by generating a data for the first
variable X_1 and generates succesively the data for X_2, ... based
on their conditional probabilities P(X_j|X_[i-1],...,X_1),
j=1,...,d.
}
\examples{
## Generation of a random sample
rmvbinary_QA(n = 10, R = diag(2), p = c(0.5, 0.6))
}
\references{
Qaqish, B. F. (2003) A family of multivariate binary distributions for simulating correlated binary variables with specified marginal means and correlations. \emph{Biometrika}, \strong{90(2)}, 455-463. \doi{10.1093/biomet/90.2.455}
}
\seealso{
For more information, please refer to the package's documentation and the tutorial: \url{https://software.klausjung-lab.de/}.
}
\author{
Jochen Kruppa, Klaus Jung
}
