% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scatter_plot.R
\name{create_scatter_plot}
\alias{create_scatter_plot}
\title{create_scatter_plot}
\usage{
create_scatter_plot(
  df = NULL,
  aes_x = NULL,
  aes_y = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  aes_size = NULL,
  aes_alpha = NULL,
  aes_linetype = NULL,
  aes_label = NULL,
  aes_label_color = "black",
  aes_label_size = 6,
  aes_label_nudge_x = 0,
  aes_label_nudge_y = -0.3,
  aes_CI_lwr = NULL,
  aes_CI_upr = NULL,
  position = position_jitter(width = 0, height = 0),
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  x_major_date_breaks = waiver(),
  x_minor_date_breaks = waiver(),
  x_date_labels = waiver(),
  x_log10 = FALSE,
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  y_log10 = FALSE,
  x_y_decimals = NULL,
  x_y_scientific = NULL,
  axis_text_size = 11,
  show_pts = TRUE,
  pts_fill = "white",
  pts_shape = 21,
  pts_stroke = 1,
  pts_color = "black",
  pts_size = 1,
  pts_line_alpha = 1,
  connect = FALSE,
  line_width = 0.6,
  line_color = "black",
  connect_linetype = "solid",
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.7,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  panel_color = "white",
  panel_border_color = "black",
  bold_y = NULL,
  bold_y_color = "black",
  bold_y_linetype = "dashed",
  CI_dir = "y",
  CI_show_line = FALSE,
  CI_show_errorbar = FALSE,
  CI_show_ribbon = FALSE,
  CI_line_color = "black",
  CI_line_width = 1,
  CI_linetype = "dashed",
  CI_errorbar_color = "black",
  CI_errorbar_width = 1,
  CI_ribbon_color = "gray70",
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame from which the scatter points are plotted.}

\item{aes_x}{The x axis variable name from 'df'. This is a required discrete factor, continuous numeric,
or Date/POSIXct variable.}

\item{aes_y}{The y axis variable name from 'df'. This is a required discrete factor or continuous numeric.}

\item{aes_color}{The variable name from df' for the variable dependent aesthetic mapping for color.}

\item{aes_fill}{The variable name from 'df' for the variable dependent aesthetic mapping for fill.}

\item{aes_size}{The variable name from 'df' for the variable dependent aesthetic mapping for size.}

\item{aes_alpha}{The variable name from 'df' for the variable dependent aesthetic mapping for alpha.}

\item{aes_linetype}{The variable name from 'df' for the variable dependent aesthetic mapping for linetype.}

\item{aes_label}{The variable name from 'df' for the variable dependent aesthetic mapping for labeling.}

\item{aes_label_color}{A string that sets the color of labels.}

\item{aes_label_size}{A numeric that sets the size of labels.}

\item{aes_label_nudge_x}{A numeric that nudges the label's horizontal position.}

\item{aes_label_nudge_y}{A numeric that nudges the label's vertical position.}

\item{aes_CI_lwr}{Sets the column from 'df' for the lower confidence interval with reference to the x or y axis.}

\item{aes_CI_upr}{Sets the column from 'df' for the upper confidence interval with reference to the x or y axis.}

\item{position}{A string or function that does a slight adjustment to overlapping points.  Typical values are
"jitter" or \code{position_jitter(width = 0.1, height = 0.1)}.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If\code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{x_limits}{Depending on the class of 'aes_x', a numeric/Date/POSIXct 2 element vector that sets the minimum
and maximum for the x axis. Use NA to refer to the existing minimum and maximum.}

\item{x_major_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact major tic locations along the x axis.}

\item{x_minor_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact minor tic locations along the x axis.}

\item{x_labels}{A character vector with the same length as 'x_major_breaks', that labels the major tics.}

\item{x_major_date_breaks}{If the class of 'aes_x' is Date/POSIXct, a string containing the number and date unit
for major breaks. Examples: "1 year", "4 sec", "3 month", "2 week".}

\item{x_minor_date_breaks}{If the class of 'aes_x' is Date/POSIXct, a string containing the number and date unit
for minor breaks.}

\item{x_date_labels}{If the class of 'aes_x' is Date/POSIXct, a string containing the format codes, the strftime
format, for the date.
Examples: \code{\%Y-\%m}, \code{\%Y/\%b/\%d}, \code{\%H-\%M-\%S}}

\item{x_log10}{A logical which if \code{TRUE} will use a log10 scale for the x axis.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and  maximum for the y axis.
Use \code{NA} to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{y_log10}{A logical which if \code{TRUE} will use a log10 scale for the y axis.}

\item{x_y_decimals}{A two element numeric vector that set the number of decimals for the x and y tic labels.}

\item{x_y_scientific}{A two element logical vector that if TRUE uses scientific notation for the x and y tic labels.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{show_pts}{A logical which if \code{FALSE} will plot only the lines if 'connect' is \code{TRUE}.}

\item{pts_fill}{A string that sets the fill color attribute of the points.}

\item{pts_shape}{A numeric integer that sets the shape attribute of the points. Typical values are 21 "circle",
22 "square", 23 "diamond", 24 "up triangle", 25 "down triangle".}

\item{pts_stroke}{A numeric that sets the drawing stroke  width attribute for a point shape.}

\item{pts_color}{A string that sets the color attribute of the points.}

\item{pts_size}{A numeric value that sets the size attribute of the points.}

\item{pts_line_alpha}{A numeric value that sets the alpha level attribute of points and connected lines.}

\item{connect}{A logical which if \code{TRUE} then points will be connected with a line.}

\item{line_width}{A numeric value that sets the width of lines if 'connect' is TRUE.}

\item{line_color}{A string that sets the color of the lines if 'connect' is TRUE.}

\item{connect_linetype}{A string that sets line type "twodash", "solid", "longdash", "dotted", "dotdash",
"dashed", "blank" if 'connect' is \code{TRUE}.}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{bold_y}{A numeric that sets the y-intercept for plotting a bold horizontal line.}

\item{bold_y_color}{A string that sets the color of 'bold_y'.}

\item{bold_y_linetype}{A string that set the linetype of 'bold_y'.}

\item{CI_dir}{A string that sets the axis orientation of the confidence intervals. Acceptable values are "x" or "y".}

\item{CI_show_line}{A logical that if \code{TRUE} shows lower/upper confidence lines.}

\item{CI_show_errorbar}{A logical that if \code{TRUE} shows error bars between 'aes_y' and lower/upper confidence lines.}

\item{CI_show_ribbon}{A logical that if \code{TRUE} shows a filled ribbon between the lower/upper confidence lines.}

\item{CI_line_color}{A string that sets the lower/upper confidence line colors.}

\item{CI_line_width}{A numeric that sets the lower/upper confidence line widths.}

\item{CI_linetype}{A string that sets the linetype for lower/upper confidence lines.}

\item{CI_errorbar_color}{A string that sets the error bars' color.}

\item{CI_errorbar_width}{A numeric that sets the error bars' width.}

\item{CI_ribbon_color}{A string that sets the fill color for the confidence interval ribbon.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function is a wrapper around ggplot2 geom_point and geom_line to produce a scatter plot.
 Function returns a ggplot2 plot object of x/y scatter points/lines. Options are provided for axis scaling and
 variable/non-variable dependent aesthetics.
}
\examples{
library(ggplot2)
library(RplotterPkg)

RplotterPkg::create_scatter_plot(
  df = ggplot2::economics,
  aes_x = "date",
  aes_y = "unemploy",
  pts_shape = 21,
  pts_fill = "black",
  line_color = "violet",
  connect = TRUE,
  title = "US Monthly Unemployment",
  subtitle = "July, 1967 to April, 2015 (in thousands)",
  x_title = "Date",
  y_title = "Unemployment",
  rot_y_tic_label = TRUE,
  x_date_labels = "\%Y-\%b",
  x_major_date_breaks = "5 year",
  y_limits = c(0, 16000),
  y_major_breaks = seq(0, 16000, 2000),
  show_minor_grids = FALSE,
  bold_y = 8000,
  bold_y_color = "red",
  bold_y_linetype = "dashed"
)

}
