% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.SDAM}
\alias{predict.SDAM}
\title{Predictions for SDAM}
\usage{
\method{predict}{SDAM}(object, newdata, ...)
}
\arguments{
\item{object}{Fitted object of class \code{SDAM}.}

\item{newdata}{New test data of class \code{data.frame} containing
the covariates for which to predict the response.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector of predictions for the new data.
}
\description{
Predicts the response for new data using a fitted SDAM.
}
\examples{
set.seed(1)
X <- matrix(rnorm(10 * 5), ncol = 5)
Y <- sin(X[, 1]) -  X[, 2] + rnorm(10)
model <- SDAM(x = X, y = Y, Q_type = "trim", trim_quantile = 0.5, nfold = 2, n_K = 1)
predict(model, newdata = data.frame(X))
}
\seealso{
\code{\link{SDAM}}
}
\author{
Cyrill Scheidegger
}
