% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-strength-training-log.R
\docType{data}
\name{strength_training_log}
\alias{strength_training_log}
\title{Strength Training Log}
\format{
A data frame with 144 rows and 8 variables:
\describe{
\item{phase}{Phase index number. Numeric from 1 to 4}
\item{week}{Week index number (within phase). Numeric from 1 to 3}
\item{day}{Day (total) index number. Numeric from 1 to 3}
\item{session}{Name of the session. Can be "Session A" or "Session B"}
\item{set}{Set index number. Numeric from 1 to 6}
\item{weight}{Weight in kg being used}
\item{reps}{Number of reps being done}
\item{eRIR}{Estimated reps-in-reserve}
}
}
\usage{
strength_training_log
}
\description{
A dataset containing strength training log for a single athlete. Strength training program
involves doing two strength training sessions, over 12 week (4 phases of 3 weeks each).
Session A involves linear wave-loading pattern starting with 2x12/10/8 reps and reaching 2x8/6/4 reps.
Session B involves constant wave-loading pattern using 2x3/2/1. This dataset contains \code{weight}
being used, as well as estimated reps-in-reserve (eRIR), which represent subjective rating
of the proximity to failure
}
\keyword{datasets}
