% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_spatial.R
\name{getSpatialNeighbors_KNN}
\alias{getSpatialNeighbors_KNN}
\title{Build Spatial Network via K-Nearest Neighbors}
\usage{
getSpatialNeighbors_KNN(
  coords,
  k = 10L,
  mutual = FALSE,
  binary = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{coords}{Numeric matrix of spatial coordinates.}

\item{k}{Integer. Number of nearest neighbors. Default is 10.}

\item{mutual}{Logical. If TRUE, only mutual nearest neighbors are connected
(both A->B and B->A must exist). Default is FALSE.}

\item{binary}{Logical. If TRUE (default), return binary adjacency matrix.
If FALSE, return distance-weighted matrix.}

\item{verbose}{Logical. Whether to print progress messages. Default is FALSE.}
}
\value{
Square numeric matrix of spatial adjacency weights.
}
\description{
Constructs a spatial adjacency matrix using K-nearest neighbors.
Each point is connected to its k nearest neighbors based on Euclidean distance.
}
\details{
Uses the RANN package for efficient nearest neighbor search with KD-trees.
The resulting network may be asymmetric (A is neighbor of B doesn't mean
B is neighbor of A) unless \code{mutual = TRUE}.
}
\examples{
set.seed(42)
coords <- cbind(x = runif(50), y = runif(50))
rownames(coords) <- paste0("spot_", 1:50)

\donttest{
if (requireNamespace("RANN", quietly = TRUE)) {
    W <- getSpatialNeighbors_KNN(coords, k = 6)
}
}

}
