% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_st_intensity_pixel.R
\name{estimate.intensity.pixel}
\alias{estimate.intensity.pixel}
\title{Kernel-based intensity estimation on a space-time grid and its components,
and test statistics for first-order separability}
\usage{
estimate.intensity.pixel(X, s.region, t.region, n.grid, edge, owin = NULL)
}
\arguments{
\item{X}{Numeric matrix/data.frame with three columns \code{(x, y, t)} giving observed events.}

\item{s.region}{Numeric matrix with two columns defining the spatial window (typically polygon vertices).
Grid limits are taken as \code{range(s.region[,1])} and \code{range(s.region[,2])}.}

\item{t.region}{Numeric vector of length 2 giving the temporal window \code{c(tmin, tmax)}.}

\item{n.grid}{Integer vector of length 3 giving grid resolution in \eqn{x}, \eqn{y}, and \eqn{t}.}

\item{edge}{List with components \code{bw} (length 3), \code{space} (length \code{nrow(X)}),
and \code{time} (length \code{nrow(X)}).}

\item{owin}{Optional observation window of class \code{"owin"} (from \pkg{spatstat.geom}).
If provided, intensity estimates outside the window are set to \code{NA}.}
}
\value{
A list with grid coordinates \code{x,y,t}, intensity estimates, the diagnostic \code{S.fun},
its marginal summaries \code{S.space} and \code{S.time}, and deviation measures.
}
\description{
Computes kernel-smoothed estimates of spatial, temporal, separable, and non-separable
spatio-temporal intensity functions on a regular space-time grid, together with
separability diagnostics used in first-order separability analysis.
}
\details{
The estimator uses product Gaussian kernels with supplied bandwidths and (Gaussian)
edge-correction factors, typically produced by \code{\link{calc.bandwidths.and.edgecorr}}.
}
\examples{

n <- 100
X <- cbind(x = stats::runif(n), y = stats::runif(n), t = stats::runif(n, 0, 10))
s.region <- matrix(c(0,0, 1,0, 1,1, 0,1), ncol=2, byrow=TRUE)
t.region <- c(0, 10)
n.grid <- c(10, 10, 5)
edge <- list(bw = c(0.05, 0.05, 0.5), space = rep(1, n), time = rep(1, n))
res <- estimate.intensity.pixel(X, s.region, t.region, n.grid, edge)
str(res)

}
\references{
Ghorbani, M., Vafaei, N., Dvořák, J., and Myllymäki, M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, 161, 107245.
}
\seealso{
\code{\link{S.based.functions}}, \code{\link{calc.bandwidths.and.edgecorr}}
}
