% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DoubleHollandWindProfile}
\alias{DoubleHollandWindProfile}
\title{Double Holland Wind Profile}
\usage{
DoubleHollandWindProfile(f, vMax, rMax, rMax2, dP, cP, rho, beta, R)
}
\arguments{
\item{f}{single coriolis parameter at the centre of TC in hz}

\item{vMax}{maximum wind velocity calculation in m/s}

\item{rMax}{radius of maximum winds in km}

\item{rMax2}{radius of outer radial winds in km}

\item{dP}{pressure differential, environmental less TC central pressure in hPa}

\item{cP}{TC central pressure in hPa}

\item{rho}{density of air in Kg/m3}

\item{beta}{exponential term for Holland vortex}

\item{R}{vector of distances from grid points to TC centre in km}
}
\value{
array with two columns for velocity and then vorticity.
//@example DoubleHollandWindProfile(-1e-4,20,20,10,980,1.15,1.2,50)
}
\description{
McConochie *et al*'s double Holland vortex model based on Cardone *et al*, 1994.This application is the Coral Sea adaptation of the double vortex model and it can also be used for concentric eye - wall configurations.
}
