% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unconstrained_aGOE.R
\name{vecd}
\alias{vecd}
\title{Flatten a symmetric matrix into a vector preserving Frobenius norm.}
\usage{
vecd(m)
}
\arguments{
\item{m}{A symmetric matrix}
}
\value{
A vector.
}
\description{
The \code{vecd} operator as used by \insertCite{schwartzman2008in;textual}{TFORGE} flattens a symmetric matrix into a vector of unique elements such that the Frobenius norm of the matrix equals the Euclidean norm of the vector. This means that the off-diagonal elements are scaled by \eqn{\sqrt{2}}{`sqrt(2)`}.
In the returned vector the diagonal elements are first then the (scaled) off-diagonal elements; this ordering is different to \code{\link[=vech]{vech()}}.
}
\details{
The \code{vecd()} function has a single line of code:

\if{html}{\out{<div class="sourceCode">}}\preformatted{c(diag(m), sqrt(2) * m[lower.tri(m, diag = FALSE)])
}\if{html}{\out{</div>}}

The matrix \code{m} is not checked for symmetry.
}
\examples{
m <- inv_vech(1:6)
vecd(m)
}
\references{
\insertAllCited{}
}
