% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_expression}
\alias{check_expression}
\alias{assert_expression}
\title{Vérifie la conformité d'une expression}
\usage{
check_expression(expr)

assert_expression(expr)
}
\arguments{
\item{expr}{une expression à évaluer}
}
\value{
En sortie la fonction retourne l'objet \code{x} (le résultat de
l'évaluation de l'expression \code{expr}) de manière invisible ou une erreur.
}
\description{
Vérifie la conformité d'une expression
}
\details{
La fonction évalue l'expression \code{expr}. Le check vérifie si la
fonction génère une erreur ou un warning. Si elle ne génère aucun message
particulier, on retourne alors l'objet \code{x} (le résultat de l'évaluation de
l'expression \code{expr}), sans erreur.

Selon le préfixe de la fonction :
\itemize{
\item si le check réussi :
\itemize{
\item la fonction \code{assert_expression} retourne l'objet \code{x} de manière
invisible;
\item la fonction \code{check_expression} retourne le booléen \code{TRUE}.
}
\item si le check échoue :
\itemize{
\item la fonction \code{assert_expression} retourne un message d'erreur;
\item la fonction \code{check_expression} retourne la chaîne de caractère
"Invalid expression".
}
}
}
\examples{

assert_expression(expr = {2 + 2})
assert_expression(expr = {is.integer(1L)})
try(assert_expression(expr = {log("a")}), silent = TRUE)

check_expression(expr = {2 + 2})
check_expression(expr = {is.integer(1L)})
check_expression(expr = {log("a")})

}
