% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelatedPfsAndOs4.R
\name{CorrelatedPfsAndOs4}
\alias{CorrelatedPfsAndOs4}
\title{Generate Correlated PFS, OS and Objective Response}
\usage{
CorrelatedPfsAndOs4(
  n,
  transition_probability,
  duration,
  death_name = "death",
  progression_name = "progression",
  response_name = "response"
)
}
\arguments{
\item{n}{integer. Number of observations.}

\item{transition_probability}{a 4x4 matrix defining transition probabilities
between stable (initial state, 1), response (2), progression (3) and
death (absorbing, 4).}

\item{duration}{integer. Duration of trial. Set it to a sufficient large
integer in practice to cover the duration of the trial (potentially be
extended).}

\item{death_name}{column name of OS in returned data frame. It must be
consistent with \code{name} in the function \code{endpoint()}.}

\item{progression_name}{column name of PFS in returned data frame. It must be
consistent with \code{name} in the function \code{endpoint()}.}

\item{response_name}{column name of objective response in returned data frame. It must be
consistent with \code{name} in the function \code{endpoint()}.}
}
\value{
A data frame of \code{n} rows and 6 columns (response, progression,
death, and their event indicators with 1 means event and 0 means censored
at duration). The column names are
\code{<death_name>}, \code{<death_name>_event}, \code{<progression_name>},
\code{<progression_name>_event}, \code{<response_name>} and
\code{<response_name>_event}.

Note that it returns time-to-response for each patients with status of
censoring at pre-set duration. If a binary indicator of response at
a time point is needed as an endpoint, we may write a wrapper function to
convert the column \code{<response_name>} to binary and remove the column
\code{<response_name>_event} from return value.
}
\description{
Generate correlated PFS, OS and objective response using the
four-states model. It can be used as custom generator of \code{endpoint()}.
}
\examples{
m <- matrix(c(0.99, 0.0035, 0.0055, 0.0010,
                 0, 0.9900, 0.0052, 0.0048,
                 0,      0, 0.9960, 0.0040,
                 0,      0,      0,      1),
             nrow = 4, byrow = TRUE)

## use as function (if you don't use TrialSimulator for simulation)

dat <- CorrelatedPfsAndOs4(1e4, m, 365 * 3)

## use as generator (if you use TrialSimulator for simulation)

ep <- endpoint(name = c('pfs', 'os', 'or'),
               type = c('tte', 'tte', 'tte'), ## OR is TTE, not binary
               generator = CorrelatedPfsAndOs4,
               transition_probability = m,
               duration = 365 * 3,
               death_name = 'os', ## rename output from generator to match with "name"
               progression_name = 'pfs',
               response_name = 'or')

ep # run it in console to see summary report

}
