% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaScan.R
\name{XenaScan}
\alias{XenaScan}
\title{Scan all rows according to user input by a regular expression}
\usage{
XenaScan(
  XenaData = UCSCXenaTools::XenaData,
  pattern = NULL,
  ignore.case = TRUE
)
}
\arguments{
\item{XenaData}{a \code{data.frame}. Default is \code{data(XenaData)}.
The input of this option can only be \code{data(XenaData)} or its subset.}

\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}

\item{ignore.case}{logical. if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}
}
\value{
a \code{data.frame}
}
\description{
\code{XenaScan()} is a function can be used before \code{\link[=XenaGenerate]{XenaGenerate()}}.
}
\examples{

x1 <- XenaScan(pattern = "Blood")
x2 <- XenaScan(pattern = "LUNG", ignore.case = FALSE)

x1 \%>\%
  XenaGenerate()
x2 \%>\%
  XenaGenerate()
}
