% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extractors.R
\docType{methods}
\name{fitted.values}
\alias{fitted.values}
\alias{fitted.values,VSLCMresults-method}
\title{Extract the partition or the probabilities of classification}
\usage{
\S4method{fitted.values}{VSLCMresults}(object, type = "partition")
}
\arguments{
\item{object}{instance of \code{\linkS4class{VSLCMresults}}.}

\item{type}{the type of prediction: probability of classification (probability) or the partition (partition)}
}
\description{
This function returns the probabilities of classification or the partition among the observations of an instance of \code{\linkS4class{VSLCMresults}}.
}
\examples{
# Data loading:
data(heart)

# Cluster analysis without variable selection (number of clusters between 1 and 3)
res <- VarSelCluster(heart[,-13], 2, vbleSelec = FALSE)

# Get the ICL value
fitted.values(res)
}
