% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWB.R
\name{calcWB}
\alias{calcWB}
\title{Calculate Water Balance from UAV or PlanateScope NDVI Data}
\usage{
calcWB(
  mypath,
  shape_site = NA,
  target_res = 5,
  last_NDVI_0 = NA,
  ET_ref = NA,
  ET_ref_dl = "DWD",
  output_year = NA,
  precip_source = precip_source,
  path_WR_precip = NA,
  irrig_sf = NA,
  irrigation_efficiency = 1,
  save_shape = TRUE,
  save_geotiff = TRUE,
  save_RDATA = TRUE,
  arable_user = NA,
  arable_pass = NA
)
}
\arguments{
\item{mypath}{Path to your project main folder (string). The main folder needs to contain the subfolders "NDVI_Files" containing your NDVI-files for your AOI.}

\item{shape_site}{shapefile of AOI (string)}

\item{target_res}{Resolution of product (integer). Default is 5 m, but can be turned down to at least 3 m.}

\item{last_NDVI_0}{Number of day with day (DOI, integer) with NDVI = 0, i.e. last day before germination.}

\item{ET_ref}{Either csv-file with reference ET for every day of vegetation period or recent date (read.csv(paste(mypath,"/ET0_Arable_2021.csv",sep=""),sep=",")) or leave at NA. When using the list, the first column needs to be ascending numerized (integer) from one on with empty header. The second column contains the reference ET value for the certain DOY (float) with header "V1". The third column needs to be the date (format "YYYY-MM-DD", e.g. "2021-05-01). When left NA (default), the reference ET is automatically downloaded from either German Weather Servcice (DWD, default) or Arable, if you have an account. This decision needs to be made in the next step.}

\item{ET_ref_dl}{If you do not have any reference ET data, leave "ET_ref" as "NA" and choose here between "DWD" to download from German Weather Service ("DWD") or "Arable" to download from your Arable account ("string"). If you choose to download from your Arable Account, you need to put in your Arable login data.}

\item{output_year}{Number of year, you are processing (format: "YYYY", e.g. 2021, integer).}

\item{precip_source}{Choose either "RADOLAN" (default, string) or "FURUNO" (string) depending on the source you would like to use.}

\item{path_WR_precip}{Choose the path to your precipitation data (string). This should be a folder containing shapefiles with precipitation data for every day during the vegetation period you are interested in. If you leave it an NA (default), precipitation data is downloaded from German Weather Service (DWD).}

\item{irrig_sf}{Path to shapefile containing the irrigation data (string), e.g. st_read(paste(mypath,"/Shapefile/Buffer_36m_all_interp.shp",sep="")). The shapefile needs to contain the following coloumns: Drck_mn (water pressure, float), Dtm_Uh_ (Date and time, string, format: "YY-MM-DD hh:mm:ss"), timedif (time difference between steps in hours, float), dst_gps (spatial distance between in m the logs of sprinkler, float), gschwn_ (speed of sprinkler in m/s, float), Brg_GPS (irrigation amount, mm, float), Dstnz_k (cumulated spatial distance between logs in m, float), DOY (day of year, integer), geometry (geometric geometry). You can also generate this shapefile by 1st using the function "DownloadRaindancer" to download all of your irrigation data that was logged by raindancer. Take note, that irrigation data can only be downloaded from the last 12 days. So you should downoad regularly. In the 2nd step you can use the function "DownloadRaindancerCombineCharts" to combine the downloaded charts and process them to the needed shapefile. The resulting shapefile is being updated witht every iteration of download.}

\item{irrigation_efficiency}{Choose irrigation efficiency, float between 0 and 1 (default). Here, irrigation efficiency is meant to be as the fraction of water that was infiltrated in the soil from the amount that was applied.}

\item{save_shape}{Save results as shapefile? (TRUE or FALSE, default: TRUE)}

\item{save_geotiff}{Save results as geotiff? (TRUE or FALSE, default: TRUE)}

\item{save_RDATA}{Save results as RDATA? (TRUE or FALSE, default: TRUE)}

\item{arable_user}{Your user name for your Arable account (string). Only necessary, if you chose "ET_ref_dl" with "Arable". Else: leave at NA.}

\item{arable_pass}{Your password for your Arable account (string). Only necessary, if you chose "ET_ref_dl" with "Arable". Else: leave at NA.}
}
\value{
Shapefiles, Geotiffs and/or RDATA-files with maps showing the water balance
}
\description{
Calculate Water Balance using DJI Phantom 4 Multispectral or PlanetScope NDVI data.
Reference Evapotranspiration can be used either from German Weather Service (DWD) or Arable Mark 2 ground stations from your site.
Precipitation is gathered from either the German Weather Service (DWD) product "RADOLAN" or FURUNO WR 2120, if available.
}
