% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_analysis_sc.R
\name{plot_network}
\alias{plot_network}
\title{Plot a Condition-Specific protein-protein interaction network with DEG Annotations}
\usage{
plot_network(g, cell_type, DEG_type, result_categories)
}
\arguments{
\item{g}{An `igraph` object representing the gene or protein interaction network.}

\item{cell_type}{Character string. The cell type label used in the plot title.}

\item{DEG_type}{Character string. The differential expression category to visualize (e.g., `"sex-dimorphic"`).}

\item{result_categories}{A `data.frame` or tibble containing at least the columns:
`"DEG_Type"`, `"Gene_Symbols"`, `"Male_avg_logFC"`, and `"Female_avg_logFC"`.}
}
\value{
A `ggplot` object representing the visualized network.
}
\description{
Visualizes a gene regulatory or protein–protein interaction network for a given 
cell type and differential expression group. Nodes are sized and colored by degree, 
and key hub genes are optionally annotated with their barplots of log fold-changes 
across sexes.
}
