% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot.adaptInv}
\alias{plot.adaptInv}
\title{Create Contour Plot of Pairwise Invasibility Analysis Results}
\usage{
\method{plot}{adaptInv}(
  x,
  res_variant = 1,
  inv_variant = 2,
  repl = 1,
  pip = TRUE,
  elast = FALSE,
  run = 1,
  filled = TRUE,
  plot.title,
  plot.axes,
  axes = TRUE,
  frame.plot = TRUE,
  auto_ylim = TRUE,
  auto_col = TRUE,
  auto_lty = TRUE,
  auto_title = FALSE,
  auto_axis = FALSE,
  auto_axis_ticks = 5,
  ...
)
}
\arguments{
\item{x}{An \code{adaptInv} object, created with function
\code{\link{invade3}()}.}

\item{res_variant}{The number of the variant representing the resident
subpopulation.}

\item{inv_variant}{The number of the variant representing the mutant
subpopulation.}

\item{repl}{The replicate number to plot, in the \code{fitness} data frame
within the \code{adaptInv} object entered in argument \code{x}.}

\item{pip}{A logical value indicating whether to produce a pairwise
invasibility plot. If \code{FALSE}, then will produce a diagnostic population
size plot. Defaults to \code{TRUE}.}

\item{elast}{A logical value indicating whether to produce an elasticity
plot. Such plots can only be produced when trait optimization is performed
during invasibility analysis. Defaults to \code{FALSE}.}

\item{run}{An integer giving the run to plot if \code{pip = FALSE}.}

\item{filled}{A logical value indicating whether to produce a filled contour
plot, or a standard contour plot. Defaults to \code{TRUE}, but reverts if
invader fitness is consistently positive, or consistently negative, relative
to the resident.}

\item{plot.title}{A title for the plot.}

\item{plot.axes}{A generic parameter providing axis information for pairwise
invasibility plots.}

\item{axes}{A logical value indicating whether to include axis lines.
Defaults to \code{TRUE}.}

\item{frame.plot}{A logical value indicating whether to frame the plot.}

\item{auto_ylim}{A logical value indicating whether the maximum of the y axis
should be determined automatically. Defaults to \code{TRUE}, but reverts to
\code{FALSE} if any setting for \code{ylim} is given. Used only if
\code{pip = FALSE}.}

\item{auto_col}{A logical value indicating whether to shift the color of
lines associated with each patch automatically. Defaults to \code{TRUE}, but
reverts to \code{FALSE} if any setting for \code{col} is given. Used only if
\code{pip = FALSE}.}

\item{auto_lty}{A logical value indicating whether to shift the line type
associated with each replicate automatically. Defaults to \code{TRUE}, but
reverts to \code{FALSE} if any setting for \code{lty} is given. Used only if
\code{pip = FALSE}.}

\item{auto_title}{A logical value indicating whether to add a title to each
plot. The plot is composed of the concatenated population and patch names.
Defaults to \code{FALSE}. Used only if \code{pip = FALSE}.}

\item{auto_axis}{A logical value indicating if the axis labels should be set
as the first variable variable in the input trait axis in the given
\code{adaptInv} object for PIPs. Defaults to \code{FALSE}.}

\item{auto_axis_ticks}{A single integer value giving the number of ticks to
include on both axes of a PIP or on the x axis of an elasticity plot, if
\code{auto_axis = TRUE}. Defaults to \code{5}, or to the number of variants
in the used trait axis, whichever is smaller.}

\item{...}{Other parameters used by functions \code{plot.default()}.}
}
\value{
A contour plot showing the overall fitness dynamics of the invader
variant, assuming a pairwise invasibility analysis.
}
\description{
Function \code{plot.adaptInv} plots pairwise invasibility contour plots,
diagnostic population plots, and elasticity plot. This function is based on
code derived from Roff's Modeling Evolution: An Introduction to Numerical
Methods (2010, Oxford University Press).
}
\section{Notes}{

By default, function \code{plot.adaptInv} produces a filled contour plot in
which grey regions show where the invader has positive fitness relative to
the resident, and white regions show where the invader has negative fitness
relative to the resident. Fitness here refers to the Lyapunov coefficient of
the invader relative to the resident, calculated over the final
\code{fitness_times} in the original call to function
\code{\link{invade3}()}.
}

\examples{
library(lefko3)
data(cypdata)

sizevector <- c(0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "SL", "D", "XSm", "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.40, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, 1000, 1000),
  type =c(1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
cypmean <- lmean(cypmatrix2r)

cyp_start <- start_input(cypmean, stage2 = c("SD", "P1", "D"),
  value = c(1000, 200, 4))

c2d_4 <- density_input(cypmean, stage3 = c("P1", "P1"), stage2= c("SD", "rep"),
  style = 2, time_delay = 1, alpha = 0.005, beta = 0.000005, type = c(2, 2))

# A simple projection allows us to find a combination of density dependence
# and running time that produces a stable quasi-equilibrium
cyp_proj <- projection3(cypmean, times = 250, start_frame = cyp_start,
  density = c2d_4, integeronly = TRUE)
plot(cyp_proj)

cyp_ta <- trait_axis(stageframe = cypframe_raw,
  stage3 = rep("P1", 15),
  stage2 = rep("rep", 15),
  multiplier = seq(from = 0.1, to = 10.0, length.out = 15),
  type = rep(2, 15))

cyp_inv <- invade3(axis = cyp_ta, mpm = cypmean, density = c2d_4, times = 350,
  starts = cyp_start, entry_time = c(0, 250), fitness_times = 30,
  var_per_run = 2)
plot(cyp_inv)

}
