\donttest{
  #Simulation of a Gaussian trawl process with exponential trawl function
  n<-2000
  Delta<-0.5

  trawlfct_par <-0.5
  distr<-"Gauss"
  distr_par<-c(0,1) #mean 0, std 1
  set.seed(233)

  a <- function(x){exp(-trawlfct_par*x)}
  path <- sim_weighted_trawl_gen(n, Delta, a,
                                 distr, distr_par)$path
  #Plot the path
  library(ggplot2)
  df <- data.frame(time = seq(0,n,1), value=path)
  p <- ggplot(df, aes(x=time, y=path))+
    geom_line()+
    xlab("l")+
    ylab("Trawl process")
  p



  result <- trawl_est(path, Delta)

  original_estimate <- result$trawlfct[1:30]
  bias_corrected <- result$trawlfct_biascor[1:30]



  # True exponential values for the same lags
  lags <- 0:(length(original_estimate)-1)
  true_vals <- a(lags * Delta)

  # Plot all three
  plot(lags, original_estimate,
       type = "l", col = "blue", lwd = 2,
       xlab = "Lag index", ylab = "Trawl function estimate",
       main = "Trawl function: Original vs bias-corrected vs true",
       ylim = range(c(original_estimate, bias_corrected, true_vals), na.rm = TRUE))
  lines(lags, bias_corrected,
        col = "red", lwd = 2, lty = 2)
  lines(lags, true_vals,
        col = "black", lwd = 2, lty = 3)

  legend("topright",
         legend = c("Original", "Bias-corrected", "True exponential"),
         col = c("blue", "red", "black"),
         lty = c(1, 2, 3), lwd = 2)
}


