% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupportFunctions.R
\name{my_results}
\alias{my_results}
\title{my_results}
\usage{
my_results(x, sd = 1, digits = 3, reduced_percentiles = FALSE)
}
\arguments{
\item{x}{Numeric vector of data values}

\item{sd}{Optional parameter giving the standard deviation of the normal
distribution used for computing the coverage probabilities. Default is 1.}

\item{digits}{Optional parameter specifying to how many digits the results
should be rounded. Default is 3.}

\item{reduced_percentiles}{Optional logical parameter specifying whether only
the upper three levels of 90%, 95%, 99% should be included.
Default is FALSE.}
}
\value{
A numeric vector containing:
\itemize{
  \item Sample mean
  \item Sample standard deviation
  \item Coverage probabilities at the specified levels
}
When reduced_percentiles=FALSE: returns 8 values(mean, sd, 6 coverage levels)
When reduced_percentiles=TRUE: returns 5 values (mean, sd, 3 coverage levels)
}
\description{
Returns summary statistics
}
\details{
This function returns the sample mean, sample standard deviation
and the coverage probabilities at levels 75%, 80%, 85%, 90%, 95%, 99%
(or just 90%, 95%, 99% if reduced_percentiles=TRUE) compared to the
standard normal quantiles. Coverage probability is calculated as the
proportion of |x| values that fall within the specified quantile range.
}
\examples{
#Simulate i.i.d.~standard normal data
set.seed(456)
data <- rnorm(10000)
#Display the sample mean, standard deviation and coverage probabilities:
my_results(data)
}
