% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_node_list}
\alias{load_tree_node_list}
\title{Build a decision tree from a hierarchical list}
\usage{
load_tree_node_list(data_list)
}
\arguments{
\item{data_list}{A nested R list representing the tree structure. Each list
element should have a \code{name} and can have other attributes like \code{question},
\code{rule}, and a sub-list named \code{nodes} containing its children.}
}
\value{
A \code{data.tree} object, fully constructed and initialised with \code{answer}
and \code{confidence} attributes set to \code{NA}.
}
\description{
Constructs a tree from a nested R list, where the hierarchy is
defined by the list's structure. It also initialises the \code{answer} and
\code{confidence} attributes required for the analysis.
}
\details{
This is a core constructor function, typically called by the
\code{load_tree_yaml()} wrapper, which handles parsing the YAML file into a list.
}
\examples{
# 1. Define the tree structure as a nested list
my_data_list <- list(
  name = "Root",
  rule = "OR",
  nodes = list(
    list(name = "Leaf A", question = "Is A true?"),
    list(name = "Branch B",
         rule = "AND",
         nodes = list(
           list(name = "Leaf B1", question = "Is B1 true?"),
           list(name = "Leaf B2", question = "Is B2 true?")
         )
    )
  )
)

# 2. Build the tree from the list
my_tree <- load_tree_node_list(my_data_list)

# 3. Print the resulting tree
print_tree(my_tree)

}
\seealso{
\code{\link[=load_tree_yaml]{load_tree_yaml()}} to read this format from a file.
}
