% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bodycomp}
\alias{bodycomp}
\title{Fish body composition}
\format{
A tibble with 12 rows and 14 columns:
\describe{
 \item{date}{date; date of data recording.}
 \item{treatment}{factor; treatment identifier.}
 \item{tank}{factor; rearing tank identifier.}
 \item{dm}{numeric; dry matter content of fish tissue in g/g.}
 \item{water}{numeric; content of fish tissue in g/g.}
 \item{ash}{numeric; content of fish tissue in g/g on dry matter 
 basis.}
 \item{energy}{numeric; gross energy content of fish tissue in kJ/g on dry 
 matter basis.}
 \item{fat}{numeric; crude fat content of fish tissue in g/g on dry 
 matter basis.}
 \item{protein}{numeric; crude protein content of fish tissue in g/g on
 dry matter basis.}
 \item{ca}{numeric; calcium content of fish tissue in mg/kg on dry matter 
 basis.}
 \item{k}{numeric; potassium content of fish tissue in mg/kg on dry matter 
 basis.}
 \item{mg}{numeric; magnesium content of fish tissue in mg/kg on dry matter 
 basis.}
 \item{na}{numeric; sodium content of fish tissue in mg/kg on dry matter 
 basis.}
 \item{phosphorus}{numeric; content of fish tissue in mg/kg on dry matter 
 basis.}
}
}
\description{
This dataset contains compositional data on the proximate composition and
some key minerals in the body of Atlantic salmon (Salmo salar) at the 
beginning and the end of a trial.
The original dataset ('BodyComposition_tank') was published by Liland et al. 
(2024) and is from the first out of two trials ('Trial A'). Alterations to 
the original data structure were done by 1) converting the double-row column 
names into single-row column names and 2) removing the 'sex' column.
}
\examples{
bodycomp

}
\references{
Liland, N., Rønnestad, I., Azevedo, M., Lai, F., Oulie, F., 
Conceição, L., Soares, F. (2024): Dataset on the performance of Atlantic 
salmon (Salmo salar) reared at different dissolved oxygen levels under 
experimental conditions. Data in Brief 57, 110983. 
https://doi.org/10.1016/j.dib.2024.110983
}
\keyword{datasets}
