% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results.dir}
\alias{results.dir}
\title{Get Results Directory Path}
\usage{
results.dir(options = NULL, options_dir = NULL)
}
\arguments{
\item{options}{\emph{[character, optional]} Name of the options file (with or
without \code{.yaml} extension). If \code{NULL}, the function first checks for a
recent export marker. If no marker is found and running interactively,
you will be prompted to select an options file.}

\item{options_dir}{\emph{[character, optional]} Directory containing the options
file. If \code{NULL}, uses the default options directory.}
}
\value{
\emph{[character]} The resolved output directory path (invisibly).
}
\description{
Returns the resolved path to the output directory where analysis
results (tables, graphics) are saved. The path is printed and returned
invisibly. When called without arguments, tries to use the most recently
exported directory without prompting for an options file.
}
\examples{
\dontrun{
# Get the most recent results directory
results.dir()

# Get results dir for a specific options file
results.dir(options = "my_analysis.yaml")
}
}
