% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_functions.R
\name{assert_function_variadic}
\alias{assert_function_variadic}
\title{Assert function is variadic}
\usage{
assert_function_variadic(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{a function to check includes \code{...} in its signature}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if function \code{x} declares \code{...}, otherwise aborts with
the error message specified by \code{msg}
}
\description{
Assert that a function signature declares the \code{...} argument (variadic
arguments).
}
\examples{
my_fun <- function(x, ...) x
assert_function_variadic(my_fun)

try({
  my_fun_no_dots <- function(x) x
  assert_function_variadic(my_fun_no_dots)
})

}
