% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_regex.R
\name{assert_string_contains}
\alias{assert_string_contains}
\title{Assert string contains a regex pattern}
\usage{
assert_string_contains(
  x,
  pattern,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{pattern}{A regular expression pattern (string)}

\item{ignore.case, perl, fixed, useBytes}{Logical flags passed to \code{\link[=grepl]{grepl()}}}

\item{msg}{A character string containing the error message to display if \code{x} does not match \code{pattern}}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} matches \code{pattern}, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert a string matches a regex pattern.
}
\examples{
try({
assert_string_contains("abc", "^a") # Passes
assert_string_contains("abc", "^b") # Throws default error
assert_string_contains("abc", "^b", msg = "Custom error message") # Throws custom error
})

}
\concept{assert_regex}
