% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strj-date.R
\name{strj_parse_date}
\alias{strj_parse_date}
\title{Parse Japanese calendar dates}
\usage{
strj_parse_date(date, format = default_format(), tz = NULL)
}
\arguments{
\item{date}{A character vector containing Japanese calendar date strings.}

\item{format}{A date-time format string following ICU conventions.}

\item{tz}{A time zone used for the resulting POSIXct values.}
}
\value{
A POSIXct vector representing the parsed dates.
}
\description{
Parses Japanese calendar date strings into POSIXct objects.

This function parses date strings formatted with the Japanese calendar
system and converts them to POSIXct values using locale-aware ICU parsing.
}
\details{
Partial date specifications are interpreted according to ICU parsing
rules and may result in completion with the current date or time
components.
}
\examples{
strj_parse_date("\u4ee4\u548c2\u5e747\u67086\u65e5")
}
