% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_output.R
\name{slides_from_rds}
\alias{slides_from_rds}
\title{Generate slides from rds files}
\usage{
slides_from_rds(
  filenames,
  outfile = paste0(tempdir(), "/output.pptx"),
  template = file.path(system.file(package = "autoslider.core"), "theme/basic.pptx")
)
}
\arguments{
\item{filenames}{List of file names}

\item{outfile}{Out file path}

\item{template}{Template file path}
}
\value{
No return value, called for side effects
}
\description{
Generate slides from rds files
}
\examples{
\dontshow{if (require(filters)) withAutoprint(\{ # examplesIf}
library(dplyr, warn.conflicts = FALSE)

data <- list(
  adsl = eg_adsl,
  adae = eg_adae,
  adtte = eg_adtte
)

filters::load_filters(
  yaml_file = system.file("filters.yml", package = "autoslider.core"),
  overwrite = TRUE
)

## For this example the outputs will be saved in a temporary directory. In a
## production run this should be the reporting event's 'output' folder instead.
output_dir <- tempdir()

spec_file <- system.file("spec.yml", package = "autoslider.core")
read_spec(spec_file) \%>\%
  filter_spec(program == "t_dm_slide") \%>\%
  generate_outputs(datasets = data) \%>\%
  decorate_outputs() \%>\%
  save_outputs(outfolder = output_dir)

slides_from_rds(list.files(file.path(output_dir, "t_dm_slide_FAS.rds")))
\dontshow{\}) # examplesIf}
}
