% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_delete_task_set}
\alias{ecs_delete_task_set}
\title{Delete Task Set}
\usage{
ecs_delete_task_set(
  cluster = NULL,
  service = NULL,
  taskSet = NULL,
  force = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the...}

\item{service}{Character. The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.}

\item{taskSet}{Character. The task set ID or full Amazon Resource Name (ARN) of the task set to delete.}

\item{force}{Logical. If \code{true}, this allows you to delete a task set even if it hasn\'t been scaled down to zero.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Deletes a specified task set within a service. This
is used when a service uses the \code{EXTERNAL} deployment controller type.
For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-services.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}
\section{cluster}{

The short name or full Amazon Resource
Name (ARN) of the cluster that hosts the service that the task set
exists in to delete.
}

\section{service}{

The short name or full Amazon
Resource Name (ARN) of the service that hosts the task set to
delete.
}

\section{taskSet}{

The task set ID or full Amazon Resource Name
(ARN) of the task set to delete.
}

\section{force}{

If \code{true}, this
allows you to delete a task set even if it hasn\'t been scaled down to
zero.
}

