% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviBartMatrix.R
\name{viviBartMatrix}
\alias{viviBartMatrix}
\title{viviBartMatrix}
\usage{
viviBartMatrix(
  trees,
  type = "standard",
  metric = "propMean",
  metricError = "CV",
  reorder = FALSE
)
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{type}{Which type of matrix to return. Either 'standard', 'vsup', 'quantiles'}

\item{metric}{Which metric to use to fill the actual values matrix. Either 'propMean' or 'count'.}

\item{metricError}{Which metric to use to fill the uncertainty matrix. Either 'SD', 'CV' or 'SE'.}

\item{reorder}{LOGICAL. If TRUE then the matrix is reordered so high values are pushed to the top left.}
}
\value{
A heatmap plot showing variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\description{
Returns a matrix or list of matrices. If type = 'standard' a
matrix filled with vivi values is returned. If type = 'vsup' two matrices are returned.
One with the actual values and another matrix of uncertainty values.
If type = 'quantiles', three matrices are returned. One for the 25%, 50%, and 75% quantiles.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)

 # VSUP Matrix
 vsupMat <- viviBartMatrix(trees = trees_data,
                           type = 'vsup',
                           metric = 'propMean',
                            metricError = 'CV')
 }

}
