% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty_retro.R
\name{estimate_uncertainty_retro}
\alias{estimate_uncertainty_retro}
\title{Estimate uncertainty parameters using retrospective nowcasts}
\usage{
estimate_uncertainty_retro(
  reporting_triangle,
  n_history_delay,
  n_retrospective_nowcasts,
  structure = get_reporting_structure(reporting_triangle),
  delay_pmf = NULL,
  validate = TRUE,
  ...
)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{n_history_delay}{Integer indicating the number of reference times
(observations) to be used in the estimate of the reporting delay, always
starting from the most recent reporting delay.}

\item{n_retrospective_nowcasts}{Integer indicating the number of
retrospective nowcast times to use for uncertainty estimation.}

\item{structure}{Integer or vector specifying the reporting structure.
If integer, divides columns evenly by that integer (with last possibly
truncated).  If vector, the sum must not be greater than or equal to the
number of columns. Default is 1 (standard triangular structure).}

\item{delay_pmf}{Vector or list of vectors of delays assumed to be indexed
starting at the first delay column in each of the matrices in
\code{retro_reporting_triangles}. If a list, must be of the same length as
\code{retro_reporting_triangles}, with elements aligning. Default is \code{NULL}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}

\item{...}{Additional arguments passed to \code{\link[=estimate_uncertainty]{estimate_uncertainty()}}.}
}
\value{
A numeric vector of uncertainty parameters with length equal to
one less than the number of columns in the reporting triangle, with each
element representing the estimate of the uncertainty parameter for each
horizon. Returns NULL if insufficient data is available for estimation.
}
\description{
Estimates uncertainty parameters for nowcasting by creating a series of
retrospective datasets from the input reporting triangle, generating point
nowcasts for those datasets, and calibrating uncertainty parameters based
on retrospective nowcast performance.

This function chains the retrospective nowcasting workflow:
\enumerate{
\item \code{\link[=truncate_to_rows]{truncate_to_rows()}} - Create retrospective snapshots
\item \code{\link[=apply_reporting_structures]{apply_reporting_structures()}} - Generate retrospective reporting
triangles
\item \code{\link[=estimate_and_apply_delays]{estimate_and_apply_delays()}} - Generate point nowcasts
\item \code{\link[=estimate_uncertainty]{estimate_uncertainty()}} - Estimate uncertainty parameters
}

For full probabilistic nowcasts (uncertainty estimation + sampling), use
\code{\link[=estimate_and_apply_uncertainty]{estimate_and_apply_uncertainty()}}.

For more control over individual steps (e.g., custom matrix preparation,
alternative aggregation), use the low-level functions directly.
}
\examples{
# Create a reporting triangle from syn_nssp_df
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 25)

uncertainty_params <- estimate_uncertainty_retro(
  rep_tri,
  n_history_delay = 30,
  n_retrospective_nowcasts = 10
)
uncertainty_params
}
\seealso{
High-level workflow wrapper functions
\code{\link{allocate_reference_times}()},
\code{\link{estimate_and_apply_delay}()},
\code{\link{estimate_and_apply_delays}()},
\code{\link{estimate_and_apply_uncertainty}()}
}
\concept{workflow_wrappers}
