% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_to_rows}
\alias{truncate_to_rows}
\title{Truncate reporting triangle by removing bottom rows}
\usage{
truncate_to_rows(
  reporting_triangle,
  n = nrow(reporting_triangle) - sum(is.na(rowSums(reporting_triangle))) - 1,
  validate = TRUE
)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{n}{Integer indicating the number of retrospective
truncated triangles to be generated, always starting from the most
recent reference time. Default is to generate truncated matrices for
each row up until there are insufficient rows to generate nowcasts
from, where the minimum requirement is one more than the  number of
horizon rows (rows containing NAs).}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{trunc_rep_tri_list} List of \code{n} truncated \code{reporting_triangle}
objects with as many rows as available given the truncation, and the same
number of columns as the input \code{reporting_triangle}.
}
\description{
Generates a list of retrospective reporting triangles by successively
removing rows from the bottom of the original triangle.
Each truncated triangle represents what would have been observed at an
earlier reference time.
This function truncates row(s) of the reporting triangle, removing the most
recent observations (starting from the bottom of the reporting triangle).
}
\examples{
# Generate multiple truncated triangles
truncated_rts <- truncate_to_rows(example_reporting_triangle, n = 2)
truncated_rts[1:2]
}
\seealso{
Retrospective data generation functions
\code{\link{apply_reporting_structure}()},
\code{\link{apply_reporting_structures}()},
\code{\link{truncate_to_row}()}
}
\concept{generate_retrospective_data}
