% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_gibbs_functions.R
\name{sample.phi}
\alias{sample.phi}
\title{Internal function to sample bin estimates for each movement variable}
\usage{
sample.phi(z.agg, alpha, nmaxclust, nbins, ndata.types)
}
\arguments{
\item{z.agg}{A list of latent cluster estimates provided by
\code{\link{sample.z}}.}

\item{alpha}{numeric. A hyperparameter for the Dirichlet distribution.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{y}.}

\item{ndata.types}{numeric. The number of data streams being analyzed.}
}
\value{
A matrix of proportion estimates that characterize distributions
  (bins) for each movement variable and possible behavioral state.
}
\description{
Estimates values of \emph{phi} matrix for use in characterizing distributions
of the movement variables. Not for calling directly by users.
}
