% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_naloxone.R
\name{est_naloxone_vec}
\alias{est_naloxone_vec}
\title{Run Bayesian estimation of naloxone number under-reporting}
\usage{
est_naloxone_vec(
  N_region,
  N_t,
  N_distributed,
  regions,
  times,
  Orders2D,
  Reported_Distributed,
  Reported_Used,
  region_name,
  psi_vec = c(0.7, 0.2, 0.1),
  max_delays = 3,
  delay_alpha = 2,
  delay_beta = 1,
  priors = the$default_priors,
  run_estimation = TRUE,
  rw_type = 1,
  chains = 4,
  iter = 2000,
  seed = 42,
  adapt_delta = 0.85,
  pars = the$default_outputs,
  include = TRUE,
  ...
)
}
\arguments{
\item{N_region}{Number of regions}

\item{N_t}{number of time steps}

\item{N_distributed}{Number of samples of reporting for distribution of kits}

\item{regions}{vector (time, region) of regions (coded 1 to N_region)}

\item{times}{vector (time, region) of regions (coded 1 to N_t)}

\item{Orders2D}{vector (time, region) of orders}

\item{Reported_Distributed}{vector (time, region) reported as distributed}

\item{Reported_Used}{vector (time, region) reported as used}

\item{region_name}{bring in region names}

\item{psi_vec}{reporting delay distribution}

\item{max_delays}{maximum delay from kit ordered to kit distributed}

\item{delay_alpha}{shape parameter for order to distributed delay
distribution}

\item{delay_beta}{shape parameter for order to distributed delay distribution}

\item{priors}{list of prior values including their mean (mu) and standard
deviation (sigma)}

\item{run_estimation}{if \code{TRUE} will sample from posterior otherwise will
sample from prior only}

\item{rw_type}{\code{1} - random walk of order one. \code{2} - random walk of order 2.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{iter}{A positive integer specifying the number of iterations
for each chain (including warmup). The default is 2000.}

\item{seed}{Seed for random number generation}

\item{adapt_delta}{(double, between 0 and 1, defaults to 0.8)}

\item{pars}{A vector of character strings specifying parameters of interest. 
    The default is \code{NA} indicating all parameters in the model. 
    If \code{include = TRUE}, only samples for parameters named in \code{pars} 
    are stored in the fitted results. Conversely, if \code{include = FALSE}, 
    samples for all parameters \emph{except} those named in \code{pars} are 
    stored in the fitted results.}

\item{include}{Logical scalar defaulting to \code{TRUE} indicating
    whether to include or exclude the parameters given by the 
    \code{pars} argument. If \code{FALSE}, only entire multidimensional
    parameters can be excluded, rather than particular elements of them.}

\item{...}{other parameters to pass to \link[rstan:stanmodel-method-sampling]{rstan::sampling}}
}
\value{
An S4 \link[rstan:stanfit-class]{rstan::stanfit} class object containing the fitted model
}
\description{
Samples from Bayesian model
}
\seealso{
Other inference: 
\code{\link{est_naloxone}()}
}
\concept{inference}
