% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_bertopic_model.R
\name{save_bertopic_model}
\alias{save_bertopic_model}
\title{Save a BERTopic Model Bundle}
\usage{
save_bertopic_model(topic_model, path)
}
\arguments{
\item{topic_model}{A list returned by \code{train_bertopic_model()}. Must contain
a Python BERTopic model at \code{topic_model$model}. Optional extras such as
probabilities, reduced embeddings, topics over time, or topics per class
are saved when present and set to \code{NULL} otherwise.}

\item{path}{Directory path to write the Python model to. The RDS companion
file is saved as \code{paste0(path, "_extras.rds")}.}
}
\value{
Invisibly returns \code{TRUE} after successful write.
}
\description{
Persist a trained BERTopic model to disk and store R-side extras in a
companion RDS file. This is the recommended way to reuse a model across
sessions when working through reticulate.
}
\examples{
\donttest{
if (exists("topic_model")) {
  save_bertopic_model(topic_model, "topic_model")
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

