% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_hierarchy.R
\name{visualize_hierarchy}
\alias{visualize_hierarchy}
\title{Visualize Topic Hierarchy Nodes using BERTopic}
\usage{
visualize_hierarchy(
  model,
  hierarchical_topics = NULL,
  filename = "topic_hierarchy",
  auto_open = TRUE
)
}
\arguments{
\item{model}{A BERTopic model object. The model must have the method \code{visualize_hierarchy}.}

\item{hierarchical_topics}{Optional. A hierarchical topics DataFrame created using the BERTopic model's \code{hierarchical_topics} method.
If provided, this object is used to generate the hierarchy visualization.}

\item{filename}{A character string specifying the name of the HTML file to save the visualization.
The default value is "topic_hierarchy". The filename should not contain illegal characters.}

\item{auto_open}{Logical. If \code{TRUE}, the HTML file will be opened automatically after being saved. Default is \code{TRUE}.}
}
\value{
The function does not return a value but saves an HTML file containing the visualization
and displays it in the current R environment.
}
\description{
This function visualizes the hierarchical clustering of topics from a BERTopic model.
If a hierarchical topics DataFrame is provided, it uses this for visualization; otherwise, it visualizes directly from the model.
The visualization is saved as an interactive HTML file, which can be opened and viewed in a web browser.
}
\examples{
\donttest{
if (exists("topic_model")) {
  visualize_hierarchy(model = topic_model, filename = "topic_hierarchy",
                      auto_open = TRUE)
  if (exists("hierarchical_topics")) {
    visualize_hierarchy(model = topic_model,
                        hierarchical_topics = hierarchical_topics,
                        filename = "topic_hierarchy",
                        auto_open = TRUE)
  }
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

