## ---- test-betaNB-beta-nb-est
lapply(
  X = 1,
  FUN = function(i,
                 text,
                 R,
                 tol) {
    message(text)
    testthat::test_that(
      paste(text, "multiple regression"),
      {
        testthat::skip_on_cran()
        if (!exists("nas1982")) {
          try(
            data(
              "nas1982",
              package = "betaNB"
            ),
            silent = TRUE
          )
        }
        df <- nas1982
        object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = df)
        nb <- NB(object, R = R)
        out <- BetaNB(nb)
        print.betanb(out)
        summary.betanb(out)
        print.summary.betanb(summary.betanb(out))
        coef.betanb(out)
        vcov.betanb(out)
        confint.betanb(out)
        confint.betanb(out, type = "bc")
        summary.betanb(out, type = "bc")
        print.summary.betanb(summary.betanb(out, type = "bc"))
        print.betanb(out, type = "bc")
        confint.betanb(out, type = "bca")
        summary.betanb(out, type = "bca")
        print.summary.betanb(summary.betanb(out, type = "bca"))
        print.betanb(out, type = "bca")
        testthat::expect_true(
          all(
            abs(
              coef.betanb(out) - c(
                .4951,
                .3915,
                .2632
              )
            ) <= tol
          )
        )
      }
    )
    testthat::test_that(
      paste(text, "simple linear regression"),
      {
        testthat::skip_on_cran()
        if (!exists("nas1982")) {
          try(
            data(
              "nas1982",
              package = "betaNB"
            ),
            silent = TRUE
          )
        }
        df <- nas1982
        object <- lm(QUALITY ~ NARTIC, data = df)
        nb <- NB(object, R = R)
        out <- BetaNB(nb)
        print.betanb(out)
        summary.betanb(out)
        print.summary.betanb(summary.betanb(out))
        coef.betanb(out)
        vcov.betanb(out)
        confint.betanb(out)
        confint.betanb(out, type = "bc")
        summary.betanb(out, type = "bc")
        print.summary.betanb(summary.betanb(out, type = "bc"))
        print.betanb(out, type = "bc")
        confint.betanb(out, type = "bca")
        summary.betanb(out, type = "bca")
        print.summary.betanb(summary.betanb(out, type = "bca"))
        print.betanb(out, type = "bca")
        testthat::expect_true(
          TRUE
        )
      }
    )
  },
  text = "test-betaNB-beta-nb-est",
  R = 5L,
  tol = 0.0001
)
