% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_summarize_operations.R
\name{seq_cluster}
\alias{seq_cluster}
\title{Cluster sequences by similarity}
\usage{
seq_cluster(x, threshold = 0.05, method = "complete")
}
\arguments{
\item{x}{a DNA, RNA or AA vector of sequences to clustered.}

\item{threshold}{Threshold value (range in [0, 1]).}

\item{method}{the clustering method (see details).}
}
\value{
An integer vector with group memberships.
}
\description{
Cluster sequences by similarity
}
\details{
The function uses \pkg{ape} \code{\link[ape]{dist.dna}} and
\code{\link[ape]{dist.aa}}
functions to compute pairwise distances among sequences and
\code{\link[stats]{hclust}} for clustering.

Computing a full pairwise diastance matrix can be computationally expensive.
It is recommended to use this function for moderate size dataset.

Supported methods are:
 \itemize{
  \item \code{"single"} (= Nearest Neighbour Clustering)
  \item \code{"complete"} (= Farthest Neighbour Clustering)
  \item \code{"average"} (= UPGMA)
  \item \code{"mcquitty"} (= WPGMA)
}
}
\examples{

x <- c("-----TACGCAGTAAAAGCTACTGATG",
       "CGTCATACGCAGTAAAAACTACTGATG",
       "CTTCATACGCAGTAAAAACTACTGATG",
       "CTTCATATGCAGTAAAAACTACTGATG",
       "CTTCATACGCAGTAAAAACTACTGATG",
       "CGTCATACGCAGTAAAAGCTACTGATG",
       "CTTCATATGCAGTAAAAGCTACTGACG")
x <- dna(x)
seq_cluster(x)

}
\seealso{
Function \code{\link{seq_consensus}} to compute consensus
and representative sequences for clusters.

Other aggregation operations: 
\code{\link{seq_consensus}()}
}
\concept{aggregation operations}
