% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bm_matrix.R
\docType{data}
\name{plot.bm_matrix}
\alias{plot.bm_matrix}
\alias{plot.bm_bitmap}
\alias{plot.bm_pixmap}
\alias{as.raster.bm_bitmap}
\alias{as.raster.bm_pixmap}
\alias{col_bitmap}
\title{Plot bitmap/pixmap objects}
\format{
An object of class \code{character} of length 4.
}
\usage{
\method{plot}{bm_bitmap}(
  x,
  ...,
  col = getOption("bittermelon.col", col_bitmap),
  interpolate = FALSE
)

\method{plot}{bm_pixmap}(x, ..., interpolate = FALSE)

\method{as.raster}{bm_bitmap}(
  x,
  native = FALSE,
  ...,
  col = getOption("bittermelon.col", col_bitmap)
)

\method{as.raster}{bm_pixmap}(x, native = FALSE, ...)

col_bitmap
}
\arguments{
\item{x}{A \code{bm_bitmap()} object}

\item{...}{Passed to \code{\link[grid:grid.raster]{grid::grid.raster()}}.}

\item{col}{Character vector of R color specifications.
First color is used for values equal to 0, second color for values equal to 1, etc.}

\item{interpolate}{Passed to \code{\link[grid:grid.raster]{grid::grid.raster()}}.}

\item{native}{If \code{TRUE} return a "nativeRaster" object instead of a "raster" object.
This will require that the suggested package \code{\link[farver:farver-package]{farver}} is installed.}
}
\value{
\code{plot.bm_bitmap()} and \code{plot.bm_pixmap()} return a \code{\link[grid:grid.raster]{grid::rasterGrob()}} object silently.
As a side effect will draw to graphics device.
\code{as.raster.bm_bitmap()} and \code{as.raster.bm_pixmap()} return "raster" objects (see \code{\link[grDevices:as.raster]{grDevices::as.raster()}}).
}
\description{
\code{plot.bm_bitmap()} plots a \code{\link[=bm_bitmap]{bm_bitmap()}} object to the graphics device
while \code{plot.bm_pixmap()} plots a \code{\link[=bm_pixmap]{bm_pixmap()}} object to the graphics device.
They are wrappers around \code{\link[grid:grid.raster]{grid::grid.raster()}} and \code{as.raster.bm_bitmap()}
or \code{as.raster.bm_pixmap()}.
which converts a bitmap glyph object to a raster object.
\code{col_bitmap} is a builtin color string vectors intended for use with the \code{col}
argument for casting \code{\link[=bm_bitmap]{bm_bitmap()}} objects to pixmap objects.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
capital_r <- bm_extend(font[[str2ucp("R")]], left = 1L)
capital_r <- bm_extend(capital_r, sides = 1L, value = 2L)  # add a border effect

plot(capital_r)

plot(capital_r, col = c("yellow", "blue", "red"))

crops <- farming_crops_16x16()
grapes <- crops$grapes$portrait
plot(grapes)
}
\seealso{
\code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_pixmap]{bm_pixmap()}}
}
\keyword{datasets}
