% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spec.R
\name{plot_spec}
\alias{plot_spec}
\title{Compare AR spectra of original and seasonally adjusted series}
\usage{
plot_spec(x)
}
\arguments{
\item{x}{A \code{boiwsa()} result object. Must contain components \code{x},
\code{sa}, and \code{trend}.}
}
\value{
A \code{ggplot2} object showing the AR spectral density estimates for
the detrended original and seasonally adjusted series.
}
\description{
Computes and plots autoregressive (AR) spectral density estimates for the
detrended original series and its seasonally adjusted counterpart. Spectra are
estimated using \code{\link[stats]{spec.ar}} with AR order set to 60. The plot
highlights frequencies corresponding to intramonthly and intrayearly cycles.
}
\examples{
\donttest{
# Not run
# Seasonal adjustment of weekly US gasoline production
res <- boiwsa(x=gasoline.data$y,dates=gasoline.data$date)
plot_spec(res)}

}
