% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{selected_variables}
\alias{selected_variables}
\alias{selected_vars}
\title{Bolasso-selected Variables}
\usage{
selected_variables(
  object,
  threshold = 0.95,
  method = c("vip", "qnt"),
  var_names_only = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \link{bolasso}.}

\item{threshold}{A numeric between 0 and 1, specifying the variable
selection threshold to use.}

\item{method}{The variable selection method to use. The two valid options
are \code{c("vip", "qnt")}. The default \code{"vip"} and is the method described in
the original Bach (2008) and complementary Bunea et al. (2011) works. The
\code{"qnt"} method is the method proposed by Abram et al. (2016).}

\item{var_names_only}{A boolean value. When \code{var_names_only = FALSE}
(the default value) this function will return a \link[tibble:tibble]{tibble::tibble} of
selected covariates and their corresponding coefficients across all
bootstrap replicates. When \code{var_names_only == TRUE}, it will return
a vector containing all selected covariate names.}

\item{...}{Additional arguments to pass to \code{\link{coef}} on
objects with class \link{bolasso} or \code{bolass_fast}.}
}
\value{
A tibble with each selected variable and its respective coefficient
for each bootstrap replicate OR a vector of the names of all selected
variables.
}
\description{
Identifies covariates that are selected by the Bolasso algorithm at
the user-defined threshold. There are two variable selection criterion
to choose between; Variable Inclusion Probability ("vip") introduced in
the original Bolasso paper (Bach, 2008) and further developed by Bunea et
al. (2011), and the Quantile ("qnt") approach proposed by Abram et
al. (2016). The desired threshold value is 1 - alpha, where alpha is some
(typically small) significance level.
}
\details{
This function returns either a \link[tibble:tibble]{tibble::tibble} of selected covariates
and their corresponding coefficients across all bootstrap replicates, or
a vector of selected covariate names.
}
\seealso{
\code{\link[glmnet:predict.glmnet]{glmnet::coef.glmnet()}} and \code{gamlr:::coef.gamlr} for details
on additional arguments to pass to \code{...}.
}
