% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_sgs.R
\name{.get_sgs_series}
\alias{.get_sgs_series}
\title{Download SGS series from Brazilian Central Bank}
\usage{
.get_sgs_series(series_id, start_date = NULL, end_date = NULL)
}
\arguments{
\item{series_id}{Numeric. SGS series ID.}

\item{start_date}{Start date (YYYY, YYYY-MM, or YYYY-MM-DD format).}

\item{end_date}{End date (YYYY, YYYY-MM, YYYY-MM-DD format, or NULL for current date).}
}
\value{
A data.frame with columns 'date' (Date) and 'value' (numeric).
}
\description{
Internal helper function to download time series data from BCB SGS API.
Uses httr2 for robust HTTP requests with automatic fallback strategy.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Example: download SELIC series (ID 432)
df <- brfinance:::.get_sgs_series(432, "2020", "2021")

head(df)
tail(df)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
