% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unemployment.R
\name{get_unemployment}
\alias{get_unemployment}
\title{Get Brazilian Unemployment Rate (PNAD Continua)}
\usage{
get_unemployment(
  start_date = "2020-01-01",
  end_date = NULL,
  language = "eng",
  labels = TRUE
)
}
\arguments{
\item{start_date}{Start date for the data period. Accepts multiple formats:
\itemize{
\item \code{"YYYY"} for year only (e.g., \code{"2020"} becomes \code{"2020-01-01"})
\item \code{"YYYY-MM"} for year and month (e.g., \code{"2020-06"} becomes \code{"2020-06-01"})
\item \code{"YYYY-MM-DD"} for a specific date
\item \code{NULL} defaults to \code{"2020-01-01"}
}}

\item{end_date}{End date for the data period. Accepts the same formats as \code{start_date}.
\itemize{
\item \code{NULL} defaults to the current date
}}

\item{language}{Language for column names in the returned data.frame:
\itemize{
\item \code{"eng"} (default): Returns columns \code{date}, \code{unemployment_rate}
\item \code{"pt"}: Returns columns \code{data}, \code{taxa_desemprego}
}}

\item{labels}{Logical indicating whether to add variable labels using the
\code{labelled} package.}
}
\value{
A data.frame with:
\itemize{
\item date (Date): Reference month
\item value (numeric): Unemployment rate (\%)
}
}
\description{
Downloads monthly unemployment rate data from the Brazilian Central Bank's
SGS (Sistema Gerenciador de Series Temporais). The series corresponds to the
unemployment rate from IBGE's Continuous PNAD survey (PNAD Continua),
replicated and made available by the Central Bank.
}
\note{
\strong{Data Source}: Brazilian Central Bank (SGS), series 24369.
The data originates from IBGE's Continuous National Household Sample Survey
(PNAD Continua) and is published with monthly frequency.

Although published monthly, the unemployment rate follows IBGE's
moving-quarter methodology.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
  # Default: from 2020 to current date (aligned with other functions)
  df <- get_unemployment()

  # Specific period with year-only format
  df2 <- get_unemployment("2018", "2023")

  # Portuguese column names and labels
  df3 <- get_unemployment(language = "pt")

  # Without variable labels
  df4 <- get_unemployment("2020-01-01", "2022-12-31", labels = FALSE)
\dontshow{\}) # examplesIf}
}
