% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bunch_viewer.R
\name{bunch_viewer}
\alias{bunch_viewer}
\title{Visualizing a histogram and potential excluded areas}
\usage{
bunch_viewer(
  earnings,
  zstar = NA,
  cf_start = 10,
  cf_end = 50,
  exclude_before = 2,
  exclude_after = 20,
  binw = NA,
  trimy = TRUE,
  report = FALSE,
  title = "Count Histogram",
  varname = "Running Variable"
)
}
\arguments{
\item{earnings}{Vector of earnings, hopefully a very large one}

\item{zstar}{Place of notch/kink (critical earning point)}

\item{cf_start}{Number of bins before the kink bin where counter-factual
histogram should start.}

\item{cf_end}{Number of bins after the kink bin where counter-factual
histogram should start.}

\item{exclude_before}{Number of excluded bins before the kink bin.}

\item{exclude_after}{Number of excluded bins after the kink bin.}

\item{binw}{Bin width.}

\item{trimy}{Logical. Should the y-axis be trimmed to better show off-bunching
histogram?}

\item{report}{Should the function return the actual histogram?}

\item{title}{Title for Plot output}

\item{varname}{Name for running variable, to be desplayed in the plot}
}
\value{
A plot, the actual histogram if report is set to TRUE.
}
\description{
This function is meant to aid find excluded bins and analysis area for a
bunching study. It displays a histogram with borders. Optionally, you can get
the actual histogram back. This is convenient, as the kink/notch point is set
as the center of a bin.
}
\examples{
ability_vec <- 4000 * rbeta(100000, 2, 5)
earning_vec <- sapply(ability_vec, earning_fun, 0.2, 0.1, 0.2, 0, 1000)
bunch_viewer(earning_vec, 1000, 20, 40, 2, 2, 20, trimy = TRUE, report = FALSE)

}
\seealso{
\code{\link{bunch}}
}
